unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, ImgList;

type
  TForm2 = class(TForm)
    ImageList1: TImageList;
    ImageList2: TImageList;
    ListView: TListView;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    ComboBox1: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TForm2.ComboBox1Change(Sender: TObject);
begin
   ListView.ViewStyle := TViewStyle(ComboBox1.ItemIndex);
end;

procedure TForm2.FormCreate(Sender: TObject);
var
	pItem   : TListItem;
   pColumn : TListColumn;
   i       : Integer;

begin
	ListView.Align :=  alClient;

   // Create a ListView item for each image in the ImageList
   ListView.SmallImages :=  ImageList1;
   ListView.LargeImages :=  ImageList1;

	for i := 0 to ImageList1.Count-1 do
   begin
      pItem :=  ListView.Items.Add();
      pItem.Caption :=  'Image' + IntToStr(i);
      pItem.ImageIndex :=  i;
   end;

   // Create two columns to show during viewing as vsReport
   pColumn :=  ListView.Columns.Add();
   pColumn.Caption :=  'Column 1';
   pColumn :=  ListView.Columns.Add();
   pColumn.Caption :=  'Column 2';

   // Add View styles and constants to the Combo Box
   ComboBox1.Items.AddObject('vsIcon', TObject(vsIcon));
   ComboBox1.Items.AddObject('vsList', TObject(vsList));

   ComboBox1.Items.AddObject('vsReport', TObject(vsReport));
   ComboBox1.Items.AddObject('vsSmallIcon', TObject(vsSmallIcon));

   // Display first item in the Combo Box
   ComboBox1.ItemIndex :=  0;
end;

end.
